[ -f .env ] && export $(cat .env | xargs)

#!/usr/bin/env bash
set -euo pipefail

# Usage: scripts/release.sh patch|minor|major
BUMP="${1:-patch}"

# 1) Dernier tag (ou 0.0.0 si aucun)
LAST_TAG=$(git describe --tags --abbrev=0 2>/dev/null || echo "v0.0.0")
# enlève le "v"
LAST="${LAST_TAG#v}"

IFS='.' read -r MAJ MIN PAT <<< "$LAST"
case "$BUMP" in
  major) MAJ=$((MAJ+1)); MIN=0; PAT=0 ;;
  minor) MIN=$((MIN+1)); PAT=0 ;;
  patch) PAT=$((PAT+1)) ;;
  *) echo "Use: patch|minor|major" >&2; exit 1 ;;
esac
NEW_TAG="v${MAJ}.${MIN}.${PAT}"

# 2) (Optionnel) vérifier que le repo est clean
if ! git diff --quiet || ! git diff --cached --quiet; then
  echo "Uncommitted changes. Commit first." >&2; exit 1
fi

# 3) Crée le tag et push (avec les tags)
git tag -a "$NEW_TAG" -m "release: $NEW_TAG"
git push --follow-tags

echo "Tagged $NEW_TAG"

## 4) Déclenche le rebuild Satis (repo 'satis-registry')
##    -> nécessite variables env BB_USER, BB_TOKEN, SATIS_WORKSPACE, SATIS_REPO, SATIS_BRANCH
#curl -u "${BB_USER}:${BB_TOKEN}" -sS \
#  -H "Content-Type: application/json" \
#  -X POST \
#  "https://api.bitbucket.org/2.0/repositories/${SATIS_WORKSPACE}/${SATIS_REPO}/pipelines/" \
#  -d "{\"target\":{\"type\":\"pipeline_ref_target\",\"ref_name\":\"${SATIS_BRANCH:-main}\",\"ref_type\":\"branch\"}}"
#
#echo "Triggered satis-registry pipeline on ${SATIS_WORKSPACE}/${SATIS_REPO}"